/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.CommonDataAnalysisRoutine;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.event.HardwareDataEvent;
import com.ibm.hwmca.base.pa.fru.HmcFruList;
import com.ibm.hwmca.base.pa.fru.HmcFruResolver;
import com.ibm.hwmca.base.pa.fru.HmcFruResolverKey;
import com.ibm.hwmca.base.pa.incident.HmcIncident;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class HardwareAnalysis
extends CommonDataAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPAHWART";
    private static final String TRACE_MASKF = "XPAHWARF";
    private static final String TRACE_MASKD = "XPAHWARD";
    private String[] message_number = new String[]{new String(), new String(), new String(), new String(), new String(), new String()};
    public static String UNKNOWN_MESSAGE = "UNKNOWN_MESSAGE";
    protected int sys_rc = -1;
    protected short comp_rc = (short)-1;
    protected CommonServiceIncident incident = null;
    protected CommonProblem problem = null;
    protected byte eventClass = (byte)10;
    protected short errorId = 0;
    protected short errorReason = 0;
    protected byte eventType = 0;
    protected Log dataLog = null;
    protected byte[] logData = null;
    protected Date eventTime = null;
    public static final byte EVENT_FROM_C_CODE = 10;
    public static String CM_ACS_RULES_BASE = "IQYP33CA";
    public static String CM_MACH_RULES_BASE = "IQYP33CM";
    public static String AUTODIAL_RULES_BASE = "IQYP33AD";
    public static String TPI_RULES_BASE = "IQYP33TP";
    protected Calendar currentCalendar = Calendar.getInstance();
    protected String cecid = null;
    protected int compRc = 0;

    public HardwareAnalysis() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        HardwareDataEvent ourEvent = (HardwareDataEvent)event;
        HmcIncident anIncident = new HmcIncident();
        this.setIncident(anIncident);
        Trace.trace(TRACE_MASKD, "Create a problem");
        CommonProblem aProblem = null;
        try {
            aProblem = this.instantiateProblem(ourEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-- analyze: couldn't create problem: " + e);
            Log theLog = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String dataString = "couldn't create problem: " + e;
            theLog.add((byte)3, dataString);
            theLog.log();
            return;
        }
        this.setProblem(aProblem);
        anIncident.setProblem(aProblem);
        this.setDataLog((Log)ourEvent.getData());
        String byteOne = new String("0b");
        this.setEventClass(this.dataLog.getLogClass());
        Trace.trace(TRACE_MASKD, "Class = " + HexString.toHex(this.dataLog.getLogClass()) + " type = " + HexString.toHex(this.dataLog.getLogType()));
        Trace.trace(TRACE_MASKD, "dataLog = " + this.dataLog.getLogBlock((byte)3).getData());
        byte[] logData = (byte[])this.dataLog.getLogBlock((byte)3).getData();
        byte[] logDataSummary = (byte[])this.dataLog.getLogBlock((byte)-16).getData();
        Trace.trace(TRACE_MASKD, "primary = " + new String(logData));
        Trace.trace(TRACE_MASKD, "summary = " + new String(logDataSummary));
        this.setLogData(logData);
        String refcode = byteOne + HexString.toHex(this.dataLog.getLogType(), true) + HexString.toHex(ourEvent.getErrorId(), true);
        refcode = refcode.toUpperCase();
        this.setEventType(this.dataLog.getLogType());
        this.setErrorId(ourEvent.getErrorId());
        this.setErrorReason(ourEvent.getErrorReason());
        String extension = "0000" + HexString.toHex(ourEvent.getErrorReason(), true);
        extension = extension.toUpperCase();
        this.setEventTime(this.dataLog.getTimestamp());
        Trace.trace(TRACE_MASKD, "refcode to be set is =(" + refcode + ")");
        Trace.trace(TRACE_MASKD, "extension to be set is =(" + extension + ")");
        Trace.trace(TRACE_MASKD, "errorId =(" + this.getErrorId() + ")");
        Trace.trace(TRACE_MASKD, "errorReason =(" + this.getErrorReason() + ")");
        Trace.trace(TRACE_MASKD, "errorId =(" + HexString.toHex(this.getErrorId()) + ")");
        Trace.trace(TRACE_MASKD, "errorReason =(" + HexString.toHex(this.getErrorReason()) + ")");
        Trace.trace(TRACE_MASKD, "errorType =(" + this.getEventType() + ")");
        aProblem.setRefcode(refcode);
        aProblem.setExtension(extension);
        Trace.trace(TRACE_MASKD, "Time of the incident = " + anIncident.getTimestamp().getTime());
        Trace.trace(TRACE_MASKD, "Begin the processing of HardwareDataEventError");
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }

    public static HmcFruList getFruList(String refcode, String fileToLookAt) {
        HmcFruList returnList = null;
        Trace.trace(TRACE_MASKD, "Created CommonFruListKey(" + refcode + ",null, " + fileToLookAt);
        HmcFruResolverKey myKey = new HmcFruResolverKey(refcode, new String(), fileToLookAt);
        HmcFruResolver myResolver = null;
        try {
            myResolver = new HmcFruResolver();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "There was a problem building myResolver HmcFruResolver Exception =" + e);
        }
        try {
            returnList = (HmcFruList)myResolver.resolve(myKey);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "There was a problem building resolving myResolver.resolve( " + myKey.getRefcode() + "," + myKey.getExtension() + "," + myKey.getXMLId() + ") Exception =" + e);
        }
        return returnList;
    }

    protected static String getBaseFilePath(String keyWord) {
        String returnPath = new String();
        try {
            returnPath = BaseFileControl.getFilePath("paconfig");
        }
        catch (Exception e) {}
        return returnPath;
    }

    protected void finishAndReport(CommonDataEvent event, CommonProblem problem, CommonServiceIncident anIncident) {
        List files;
        Trace.trace(TRACE_MASKD, "call CommonServiceAnalysisRoutin.getFrulist(" + problem.getRefcode() + "," + "hardware_src.xml");
        problem.setCommonFruListKey(new HmcFruResolverKey(problem.getRefcode(), null, "hardware_src.xml"));
        HmcFruList thisFruList = HardwareAnalysis.getFruList(problem.getRefcode(), "hardware_src.xml");
        if (thisFruList != null) {
            problem.addFruList(thisFruList);
        }
        Trace.trace(TRACE_MASKD, "About to do AssociatedFiles ");
        if (event == null) {
            Trace.trace(TRACE_MASKD, "event = null");
        }
        if ((files = event.getAssociatedFileList()) != null) {
            Trace.trace(TRACE_MASKD, "AssociatedFiles is not null size= " + files.size());
            anIncident.addAssociateFile(event.getAssociatedFileList());
        } else {
            Trace.trace(TRACE_MASKD, "No AssociatedFiles is not null size= ");
        }
        ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        this.reportIncident(event, anIncident, cad.getInitialTimeoutEvent(this), cad.getHardwareWait());
    }

    public byte getEventType() {
        return this.eventType;
    }

    public void setEventType(byte eventType) {
        this.eventType = eventType;
    }

    public short getErrorId() {
        return this.errorId;
    }

    public short getErrorReason() {
        return this.errorReason;
    }

    public void setErrorId(short errorId) {
        this.errorId = errorId;
    }

    public void setErrorReason(short errorReason) {
        this.errorReason = errorReason;
    }

    public int getCompRc() {
        return this.compRc;
    }

    public void setCompRc(int compRc) {
        this.compRc = compRc;
    }

    public byte getEventClass() {
        return this.eventClass;
    }

    public void setEventClass(byte eventClass) {
        this.eventClass = eventClass;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public short buildErrorId(byte[] logData) {
        String refcode = HexString.toHex(logData[1], true) + HexString.toHex(logData[0], true);
        refcode = refcode.toUpperCase();
        return Short.parseShort(refcode);
    }

    public byte[] getLogData() {
        return this.logData;
    }

    public void setLogData(byte[] logData) {
        this.logData = logData;
    }

    public CommonServiceIncident getIncident() {
        return this.incident;
    }

    public void setIncident(CommonServiceIncident incident) {
        this.incident = incident;
    }

    public Log getDataLog() {
        return this.dataLog;
    }

    public void setDataLog(Log dataLog) {
        this.dataLog = dataLog;
    }

    public int getComp_rc() {
        return this.comp_rc;
    }

    public int getSys_rc() {
        return this.sys_rc;
    }

    public void setComp_rc(short comp_rc) {
        this.comp_rc = comp_rc;
    }

    public void setSys_rc(int sys_rc) {
        this.sys_rc = sys_rc;
    }

    public CommonProblem getProblem() {
        return this.problem;
    }

    public void setProblem(CommonProblem problem) {
        this.problem = problem;
    }

    private void setProblemTransmitFlag(CommonProblem problem) {
        switch (this.getEventType()) {
            case 49: 
            case 92: {
                if (this.getErrorId() < 1024 || this.getErrorId() >= 1280) {
                    Trace.trace(TRACE_MASKD, ": Transmit.");
                    this.problem.setTransmit(true);
                    break;
                }
            }
            case -91: 
            case -90: 
            case -68: 
            case 119: {
                Trace.trace(TRACE_MASKD, ": Do not transmit.");
                this.problem.setTransmit(false);
                break;
            }
            default: {
                this.problem.setTransmit(true);
            }
        }
    }
}

